# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 1999,2002 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
package CT::MC;
# "@(#)63   1.13   src/rsct/rmc/ext/CT/MC/MC.pm, rmccli, rsct_rpyxh, rpyxht1f3 7/26/02 15:54:12"

use strict;
use CT::CT;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
    MC_ELIB
    MC_ESESSREFUSED
    MC_ESESSINTRPT
    MC_ESESSENDED
    MC_EINVALIDSESS
    MC_ENODSCRP
    MC_EINVALIDDSCRP
    MC_EINVALIDCMD
    MC_ENOCMDS
    MC_ESENTENDED
    MC_ESENTINTRPT
    MC_EINVALIDDATA
    MC_ECMDGRPSLIMIT
    MC_ECMDGRPLIMIT
    MC_EINVALIDEID
    MC_EINVALIDOPT
    MC_EBUSY
    MC_ENOMEM
    MC_EAGAIN
    MC_EINVALIDCB
    MC_EINVALIDRSPPTR
    MC_EINVALIDCNTPTR
    MC_EINVALIDRSRCCNT
    MC_ECMDTOOLARGE
    MC_ELIBNOMEM
    MC_EORDERGROUP
    MC_ETARGETMISMATCH
    MC_EINVALIDDATATYPE
    MC_EINVALIDVALUEPTR
    MC_EINVALIDSBSLEN
    MC_EINVALIDSDTYPE
    MC_EINVALIDCONTACT
    MC_ENOTSUPPORTED
    MC_EDEADLOCK
    MC_EINVALIDNAME
    MC_EINVALIDSTRING
    MC_ELIBSECURITY
    MC_ESUBSECURITY
    MC_EAUTHENTICATE
    MC_EAUTHORIZATION
    MC_EMUTUALAUTHENT

    MC_CMD_GRPS_LIMIT
    MC_CMD_GRP_LIMIT

    MC_VERSION
);

@EXPORT_OK = qw(
    MC_SESSION_OPTS_NONE                MC_SESSION_OPTS_LOCAL_SCOPE
    MC_SESSION_OPTS_SR_SCOPE            MC_SESSION_OPTS_DM_SCOPE
    MC_SESSION_OPTS_PRIVATE             MC_SESSION_OPTS_DM_SR_LOCAL_SCOPE

    MC_OFFLINE_OPTS_NONE                MC_OFFLINE_OPTS_FAILED

    MC_DISPATCH_OPTS_WAIT               MC_DISPATCH_OPTS_ASSIGN

    MC_CMD_GRP_OPTS_NONE                MC_CMD_GRP_OPTS_ORDERED 
    MC_CMD_GRP_OPTS_NO_INTERLEAVE       MC_CMD_GRP_OPTS_STOP_ON_ERROR

    MC_REG_OPTS_NONE                    MC_REG_OPTS_NO_REG
    MC_REG_OPTS_IMMED_EVAL              MC_REG_OPTS_REARM_EVENT
    MC_REG_OPTS_KEEP_REG

    MC_QDEF_OPTS_NONE                   MC_QDEF_OPTS_NODSCRP

    MC_RSRC_CLASS_RESERVED              MC_RSRC_CLASS_HAS_RSRC_INSTS
    MC_RSRC_CLASS_HAS_CTRL_INTERFACE    MC_RSRC_CLASS_CAN_DEFINE_UNDEFINE
    MC_RSRC_CLASS_INVOKE_PHASE0         MC_RSRC_CLASS_INVOKE_PHASE1
    MC_RSRC_CLASS_PERFMON_SUPPORTED     MC_RSRC_CLASS_HAS_CONSTRAINTS
    MC_RSRC_CLASS_RMC_ELECTS_COORD      MC_RSRC_CLASS_MTYPE_SUBDIVIDED
    MC_RSRC_CLASS_MTYPE_CENTRALIZED     MC_RSRC_CLASS_MTYPE_GLOBALIZED

    MC_RSRC_PATTR_READ_ONLY             MC_RSRC_PATTR_REQD_FOR_DEFINE
    MC_RSRC_PATTR_INVAL_FOR_DEFINE      MC_RSRC_PATTR_OPTION_FOR_DEFINE
    MC_RSRC_PATTR_SELECTABLE            MC_RSRC_PATTR_PUBLIC

    MC_RSRC_DATTR_PUBLIC

    MC_SD_USAGE_PATTR_RSRC_CLASS        MC_SD_USAGE_PATTR_RESOURCE
    MC_SD_USAGE_DATTR_RSRC_CLASS        MC_SD_USAGE_DATTR_RESOURCE
    MC_SD_USAGE_RSRC_ACTION_INPUT       MC_SD_USAGE_RSRC_ACTION_RESPONSE
    MC_SD_USAGE_CLASS_ACTION_INPUT      MC_SD_USAGE_CLASS_ACTION_RESPONSE
    MC_SD_USAGE_ERROR_INPUT             MC_SD_USAGE_DEFINE_ARG
    MC_SD_USAGE_UNDEFINE_ARG            MC_SD_USAGE_ONLINE_ARG
    MC_SD_USAGE_OFFLINE_ARG             MC_SD_USAGE_RESET_ARG

    MC_VV_USAGE_PATTR_RSRC_CLASS        MC_VV_USAGE_PATTR_RESOURCE
    MC_VV_USAGE_DATTR_RSRC_CLASS        MC_VV_USAGE_DATTR_RESOURCE
    MC_VV_USAGE_RSRC_ACTION_INPUT       MC_VV_USAGE_CLASS_ACTION_INPUT
    MC_VV_USAGE_ERROR_INPUT             MC_VV_USAGE_DEFINE_ARG
    MC_VV_USAGE_UNDEFINE_ARG            MC_VV_USAGE_ONLINE_ARG
    MC_VV_USAGE_OFFLINE_ARG             MC_VV_USAGE_RESET_ARG

    MC_ACTION_TYPE_RESOURCE             MC_ACTION_TYPE_CLASS

    MC_RSRC_ACTION_LONG_RUNNING         MC_RSRC_ACTION_PUBLIC

    MC_RSRC_ERROR_PUBLIC

    MC_CHK_OPTS_NONE                    MC_CHK_OPTS_FIX

    MC_CHECK_FIXED

    MC_EVENT_RE_ARM                     MC_EVENT_EXPR_FALSE
    MC_EVENT_IMMED_EVAL                 MC_EVENT_REFRESH
    MC_EVENT_MISSING_PATTR              MC_EVENT_UNASSIGN

    class_query_d_bp
    class_query_p_bp
    class_set_bp
    constraint_advisory_bp
    define_resource_bp
    do_integrity_check_bp
    end_session
    enum_constraints_bp
    enumerate_resources_bp
    free_descriptor
    free_response
    get_control_log_bp
    get_descriptor
    invoke_action_bp
    invoke_class_action_bp
    offline_bp
    online_bp
    reset_bp
    qdef_actions_bp
    qdef_err_inject_bp
    qdef_d_attribute_bp
    qdef_dependencies_bp
    qdef_p_attribute_bp
    qdef_resource_class_bp
    qdef_sbs_bp
    qdef_sd_bp
    qdef_valid_values_bp
    query_d_handle_bp
    query_d_select_bp
    query_p_handle_bp
    query_p_select_bp
    refresh_config_bp
    reg_class_event_bp
    reg_event_handle_bp
    reg_event_select_bp
    set_handle_bp
    set_select_bp
    start_session
    undefine_resource_bp
    unreg_event_bp
    validate_rsrc_hndl_bp
);

# use the export tags to reference enum by name

%EXPORT_TAGS = (
mc_session_opts_t => [qw(
    MC_SESSION_OPTS_NONE
    MC_SESSION_OPTS_LOCAL_SCOPE
    MC_SESSION_OPTS_SR_SCOPE
    MC_SESSION_OPTS_DM_SCOPE
    MC_SESSION_OPTS_PRIVATE
    MC_SESSION_OPTS_DM_SR_LOCAL_SCOPE
)],

mc_offline_opts_t => [qw(
    MC_OFFLINE_OPTS_NONE
    MC_OFFLINE_OPTS_FAILED
)],

mc_dispatch_opts_t => [qw(
    MC_DISPATCH_OPTS_WAIT
    MC_DISPATCH_OPTS_ASSIGN
)],

mc_cmd_grp_opts_t => [qw(
    MC_CMD_GRP_OPTS_NONE
    MC_CMD_GRP_OPTS_ORDERED
    MC_CMD_GRP_OPTS_NO_INTERLEAVE
    MC_CMD_GRP_OPTS_STOP_ON_ERROR
)],

mc_reg_opts_t => [qw(
    MC_REG_OPTS_NONE 
    MC_REG_OPTS_NO_REG
    MC_REG_OPTS_IMMED_EVAL
    MC_REG_OPTS_REARM_EVENT
    MC_REG_OPTS_KEEP_REG
)],

mc_qdef_opts_t => [qw(
    MC_QDEF_OPTS_NONE
    MC_QDEF_OPTS_NODSCRP
)],

mc_rsrc_class_props_t => [qw(
    MC_RSRC_CLASS_RESERVED
    MC_RSRC_CLASS_HAS_RSRC_INSTS
    MC_RSRC_CLASS_HAS_CTRL_INTERFACE
    MC_RSRC_CLASS_CAN_DEFINE_UNDEFINE
    MC_RSRC_CLASS_INVOKE_PHASE0
    MC_RSRC_CLASS_INVOKE_PHASE1
    MC_RSRC_CLASS_PERFMON_SUPPORTED
    MC_RSRC_CLASS_HAS_CONSTRAINTS
    MC_RSRC_CLASS_RMC_ELECTS_COORD
    MC_RSRC_CLASS_MTYPE_SUBDIVIDED
    MC_RSRC_CLASS_MTYPE_CENTRALIZED
    MC_RSRC_CLASS_MTYPE_GLOBALIZED
)],

mc_pattr_props_t => [qw(
    MC_RSRC_PATTR_READ_ONLY
    MC_RSRC_PATTR_REQD_FOR_DEFINE
    MC_RSRC_PATTR_INVAL_FOR_DEFINE
    MC_RSRC_PATTR_OPTION_FOR_DEFINE
    MC_RSRC_PATTR_SELECTABLE
    MC_RSRC_PATTR_PUBLIC
)],

mc_dattr_props_t => [qw(
    MC_RSRC_DATTR_PUBLIC
)],

mc_sd_usage_t => [qw(
    MC_SD_USAGE_PATTR_RSRC_CLASS
    MC_SD_USAGE_PATTR_RESOURCE
    MC_SD_USAGE_DATTR_RSRC_CLASS
    MC_SD_USAGE_DATTR_RESOURCE
    MC_SD_USAGE_RSRC_ACTION_INPUT
    MC_SD_USAGE_RSRC_ACTION_RESPONSE
    MC_SD_USAGE_CLASS_ACTION_INPUT
    MC_SD_USAGE_CLASS_ACTION_RESPONSE
    MC_SD_USAGE_ERROR_INPUT
    MC_SD_USAGE_DEFINE_ARG
    MC_SD_USAGE_UNDEFINE_ARG
    MC_SD_USAGE_ONLINE_ARG
    MC_SD_USAGE_OFFLINE_ARG
    MC_SD_USAGE_RESET_ARG
)],

mc_vv_usage_t => [qw(
    MC_VV_USAGE_PATTR_RSRC_CLASS
    MC_VV_USAGE_PATTR_RESOURCE
    MC_VV_USAGE_DATTR_RSRC_CLASS
    MC_VV_USAGE_DATTR_RESOURCE
    MC_VV_USAGE_RSRC_ACTION_INPUT
    MC_VV_USAGE_CLASS_ACTION_INPUT
    MC_VV_USAGE_ERROR_INPUT
    MC_VV_USAGE_DEFINE_ARG
    MC_VV_USAGE_UNDEFINE_ARG
    MC_VV_USAGE_ONLINE_ARG
    MC_VV_USAGE_OFFLINE_ARG
    MC_VV_USAGE_RESET_ARG
)],

mc_action_type_t => [qw(
    MC_ACTION_TYPE_RESOURCE
    MC_ACTION_TYPE_CLASS
)],

mc_action_props_t => [qw(
    MC_RSRC_ACTION_LONG_RUNNING
    MC_RSRC_ACTION_PUBLIC
)],

mc_error_props_t => [qw(
    MC_RSRC_ERROR_PUBLIC
)],

mc_integrity_check_opts_t => [qw(
    MC_CHK_OPTS_NONE
    MC_CHK_OPTS_FIX
)],

mc_check_flags_t => [qw(
    MC_CHECK_FIXED
)],

mc_event_flags_t => [qw(
    MC_EVENT_RE_ARM
    MC_EVENT_EXPR_FALSE
    MC_EVENT_IMMED_EVAL
    MC_EVENT_REFRESH
    MC_EVENT_MISSING_PATTR
    MC_EVENT_UNASSIGN
)],
);  # end %EXPORT_TAGS

# --------------------------------------------------------------------
# RMC enums defined for use in PERL from ct_mc.h
# Available Enum Definitions (constants)
# --------------------------------------------------------------------
# enums from ct_mc.h as of 1/11/01 sccs id 1.27 1/04/01

# mc_session_opts_t
use constant MC_SESSION_OPTS_NONE           => 0x0000;
use constant MC_SESSION_OPTS_LOCAL_SCOPE    => 0x0001;
use constant MC_SESSION_OPTS_SR_SCOPE       => 0x0002;
use constant MC_SESSION_OPTS_DM_SCOPE       => 0x0004;
use constant MC_SESSION_OPTS_PRIVATE        => 0x0008;
use constant MC_SESSION_OPTS_DM_SR_LOCAL_SCOPE => 0x0200;

# mc_offline_opts_t
use constant MC_OFFLINE_OPTS_NONE           => 0x0000;
use constant MC_OFFLINE_OPTS_FAILED         => 0x0001;

# mc_dispatch_opts_t (TODO have values been assigned in ct_mc.h yet?)
use constant MC_DISPATCH_OPTS_WAIT          => 0;
use constant MC_DISPATCH_OPTS_ASSIGN        => 1;

# mc_cmd_grp_opts_t
use constant MC_CMD_GRP_OPTS_NONE           => 0x0000;
use constant MC_CMD_GRP_OPTS_ORDERED        => 0x0001;
use constant MC_CMD_GRP_OPTS_NO_INTERLEAVE  => 0x0002;
use constant MC_CMD_GRP_OPTS_STOP_ON_ERROR  => 0x0004;

# mc_reg_opts_t
use constant MC_REG_OPTS_NONE               => 0x0000;
use constant MC_REG_OPTS_NO_REG             => 0x0001;
use constant MC_REG_OPTS_IMMED_EVAL         => 0x0002;
use constant MC_REG_OPTS_REARM_EVENT        => 0x0004;
use constant MC_REG_OPTS_KEEP_REG           => 0x0008;

# mc_qdef_opts_t
use constant MC_QDEF_OPTS_NONE              => 0x0000;
use constant MC_QDEF_OPTS_NODSCRP           => 0x0001;

# mc_rsrc_class_props_t
use constant MC_RSRC_CLASS_RESERVED              => 0x0001;
use constant MC_RSRC_CLASS_HAS_RSRC_INSTS        => 0x0002;
use constant MC_RSRC_CLASS_HAS_CTRL_INTERFACE    => 0x0004;
use constant MC_RSRC_CLASS_CAN_DEFINE_UNDEFINE   => 0x0008;
use constant MC_RSRC_CLASS_INVOKE_PHASE0         => 0x0010;
use constant MC_RSRC_CLASS_INVOKE_PHASE1         => 0x0020;
use constant MC_RSRC_CLASS_PERFMON_SUPPORTED     => 0x0040;
use constant MC_RSRC_CLASS_HAS_CONSTRAINTS       => 0x0080;
use constant MC_RSRC_CLASS_RMC_ELECTS_COORD      => 0x0100;
use constant MC_RSRC_CLASS_MTYPE_SUBDIVIDED      => 0x2000;
use constant MC_RSRC_CLASS_MTYPE_CENTRALIZED     => 0x4000;
use constant MC_RSRC_CLASS_MTYPE_GLOBALIZED      => 0x8000;

# mc_pattr_props_t
use constant MC_RSRC_PATTR_READ_ONLY            => 0x0001;
use constant MC_RSRC_PATTR_REQD_FOR_DEFINE      => 0x0002;
use constant MC_RSRC_PATTR_INVAL_FOR_DEFINE     => 0x0004;
use constant MC_RSRC_PATTR_OPTION_FOR_DEFINE    => 0x0008;
use constant MC_RSRC_PATTR_SELECTABLE           => 0x0010;
use constant MC_RSRC_PATTR_PUBLIC               => 0x0020;

# mc_dattr_props_t
use constant MC_RSRC_DATTR_PUBLIC               => 0x0020;

# mc_sd_usage_t (TODO have values been assigned in ct_mc.h yet?)
use constant MC_SD_USAGE_PATTR_RSRC_CLASS       => 0;
use constant MC_SD_USAGE_PATTR_RESOURCE         => 1;
use constant MC_SD_USAGE_DATTR_RSRC_CLASS       => 2;
use constant MC_SD_USAGE_DATTR_RESOURCE         => 3;
use constant MC_SD_USAGE_RSRC_ACTION_INPUT      => 4;
use constant MC_SD_USAGE_RSRC_ACTION_RESPONSE   => 5;
use constant MC_SD_USAGE_CLASS_ACTION_INPUT     => 6;
use constant MC_SD_USAGE_CLASS_ACTION_RESPONSE  => 7;
use constant MC_SD_USAGE_ERROR_INPUT            => 8;
use constant MC_SD_USAGE_DEFINE_ARG             => 9;
use constant MC_SD_USAGE_UNDEFINE_ARG           => 10;
use constant MC_SD_USAGE_ONLINE_ARG             => 11;
use constant MC_SD_USAGE_OFFLINE_ARG            => 12;
use constant MC_SD_USAGE_RESET_ARG              => 13;

# mc_vv_usages_t (TODO have values been assigned in ct_mc.h yet?)
use constant MC_VV_USAGE_PATTR_RSRC_CLASS       => 0;
use constant MC_VV_USAGE_PATTR_RESOURCE         => 1;
use constant MC_VV_USAGE_DATTR_RSRC_CLASS       => 2;
use constant MC_VV_USAGE_DATTR_RESOURCE         => 3; 
use constant MC_VV_USAGE_RSRC_ACTION_INPUT      => 4;
use constant MC_VV_USAGE_CLASS_ACTION_INPUT     => 5;
use constant MC_VV_USAGE_ERROR_INPUT            => 6;
use constant MC_VV_USAGE_DEFINE_ARG             => 7;
use constant MC_VV_USAGE_UNDEFINE_ARG           => 8;
use constant MC_VV_USAGE_ONLINE_ARG             => 9;
use constant MC_VV_USAGE_OFFLINE_ARG            => 10;
use constant MC_VV_USAGE_RESET_ARG              => 11;

# mc_action_type_t (TODO have values been assigned in ct_mc.h yet?)
use constant MC_ACTION_TYPE_RESOURCE            => 0;
use constant MC_ACTION_TYPE_CLASS               => 1;

# mc_action_props_t
use constant MC_RSRC_ACTION_LONG_RUNNING    => 0x0001;
use constant MC_RSRC_ACTION_PUBLIC          => 0x0002;

# mc_error_props_t
use constant MC_RSRC_ERROR_PUBLIC           => 0x0001;

# mc_integrity_check_opts_t
use constant MC_CHK_OPTS_NONE               => 0x0000;
use constant MC_CHK_OPTS_FIX                => 0x0001;

# mc_check_flags_t
use constant MC_CHECK_FIXED                 => 0x0001;

# mc_event_flags_t
use constant MC_EVENT_RE_ARM                => 0x0001;
use constant MC_EVENT_EXPR_FALSE            => 0x0002;
use constant MC_EVENT_IMMED_EVAL            => 0x0004;
use constant MC_EVENT_REFRESH               => 0x0008;
use constant MC_EVENT_MISSING_PATTR         => 0x0010;
use constant MC_EVENT_UNASSIGNE             => 0x0020;


$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined MC macro $constname";
    }
    }
#    *$AUTOLOAD = sub () { $val };
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}

bootstrap CT::MC $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__


=head1 NAME

CT::MC - Perl extensions for RSCT RMC ct_mc.h


=head1 SYNOPSIS

    use CT::MC;
    use CT::MC qw(:<export tag>);
    use CT::MC qw(<exported constant list>);      


=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) Resource Monitoring and Control (RMC) Commands.
RMC Commands are located in /usr/sbin/rsct/bin.
Some of the RMC Commands are:
lsrsrc, lsrsrcdef, mkrsrc, rmrsrc, chrsrc, refrsrc, lsactdef.

The Perl to C Extensions for RSCT RMC, 
CT::MC, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.

=head1 EXPORTED CONSTANTS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct_mc.h

    MC_ELIB
    MC_ESESSREFUSED
    MC_ESESSINTRPT
    MC_ESESSENDED
    MC_EINVALIDSESS
    MC_ENODSCRP
    MC_EINVALIDDSCRP
    MC_EINVALIDCMD
    MC_ENOCMDS
    MC_ESENTENDED
    MC_ESENTINTRPT
    MC_EINVALIDDATA
    MC_ECMDGRPSLIMIT
    MC_ECMDGRPLIMIT
    MC_EINVALIDEID
    MC_EINVALIDOPT
    MC_EBUSY
    MC_ENOMEM
    MC_EAGAIN
    MC_EINVALIDCB
    MC_EINVALIDRSPPTR
    MC_EINVALIDCNTPTR
    MC_EINVALIDRSRCCNT
    MC_ECMDTOOLARGE
    MC_ELIBNOMEM
    MC_EORDERGROUP
    MC_ETARGETMISMATCH
    MC_EINVALIDDATATYPE
    MC_EINVALIDVALUEPTR
    MC_EINVALIDSBSLEN
    MC_EINVALIDSDTYPE
    MC_EINVALIDCONTACT
    MC_ENOTSUPPORTED
    MC_EDEADLOCK
    MC_EINVALIDNAME
    MC_EINVALIDSTRING
    MC_ELIBSECURITY
    MC_ESUBSECURITY
    MC_EAUTHENTICATE
    MC_EAUTHORIZATION
    MC_EMUTUALAUTHENT

    MC_CMD_GRPS_LIMIT
    MC_CMD_GRP_LIMIT

    MC_VERSION


=head1 EXPORTED TAGS

For more information regarding these exported tags see the file:
    /usr/include/rsct/ct_mc.h

mc_session_opts_t => [qw(
    MC_SESSION_OPTS_NONE
    MC_SESSION_OPTS_LOCAL_SCOPE
    MC_SESSION_OPTS_SR_SCOPE
    MC_SESSION_OPTS_DM_SCOPE
    MC_SESSION_OPTS_PRIVATE
    MC_SESSION_OPTS_DM_SR_LOCAL_SCOPE
)],

mc_offline_opts_t => [qw(
    MC_OFFLINE_OPTS_NONE
    MC_OFFLINE_OPTS_FAILED
)],

mc_dispatch_opts_t => [qw(
    MC_DISPATCH_OPTS_WAIT
    MC_DISPATCH_OPTS_ASSIGN
)],

mc_cmd_grp_opts_t => [qw(
    MC_CMD_GRP_OPTS_NONE
    MC_CMD_GRP_OPTS_ORDERED
    MC_CMD_GRP_OPTS_NO_INTERLEAVE
    MC_CMD_GRP_OPTS_STOP_ON_ERROR
)],

mc_reg_opts_t => [qw(
    MC_REG_OPTS_NONE
    MC_REG_OPTS_NO_REG
    MC_REG_OPTS_IMMED_EVAL
    MC_REG_OPTS_REARM_EVENT
    MC_REG_OPTS_KEEP_REG
)],

mc_qdef_opts_t => [qw(
    MC_QDEF_OPTS_NONE
    MC_QDEF_OPTS_NODSCRP
)],

mc_rsrc_class_props_t => [qw(
    MC_RSRC_CLASS_RESERVED
    MC_RSRC_CLASS_HAS_RSRC_INSTS
    MC_RSRC_CLASS_HAS_CTRL_INTERFACE
    MC_RSRC_CLASS_CAN_DEFINE_UNDEFINE
    MC_RSRC_CLASS_INVOKE_PHASE0
    MC_RSRC_CLASS_INVOKE_PHASE1
    MC_RSRC_CLASS_PERFMON_SUPPORTED
    MC_RSRC_CLASS_HAS_CONSTRAINTS
    MC_RSRC_CLASS_RMC_ELECTS_COORD
    MC_RSRC_CLASS_MTYPE_SUBDIVIDED
    MC_RSRC_CLASS_MTYPE_CENTRALIZED
    MC_RSRC_CLASS_MTYPE_GLOBALIZED
)],

mc_pattr_props_t => [qw(
    MC_RSRC_PATTR_READ_ONLY
    MC_RSRC_PATTR_REQD_FOR_DEFINE
    MC_RSRC_PATTR_INVAL_FOR_DEFINE
    MC_RSRC_PATTR_OPTION_FOR_DEFINE
    MC_RSRC_PATTR_SELECTABLE
    MC_RSRC_PATTR_PUBLIC
)],

mc_dattr_props_t => [qw(
    MC_RSRC_DATTR_PUBLIC
)],

mc_sd_usage_t => [qw(
    MC_SD_USAGE_PATTR_RSRC_CLASS
    MC_SD_USAGE_PATTR_RESOURCE
    MC_SD_USAGE_DATTR_RSRC_CLASS
    MC_SD_USAGE_DATTR_RESOURCE
    MC_SD_USAGE_RSRC_ACTION_INPUT
    MC_SD_USAGE_RSRC_ACTION_RESPONSE
    MC_SD_USAGE_CLASS_ACTION_INPUT
    MC_SD_USAGE_CLASS_ACTION_RESPONSE
    MC_SD_USAGE_ERROR_INPUT
    MC_SD_USAGE_DEFINE_ARG
    MC_SD_USAGE_UNDEFINE_ARG
    MC_SD_USAGE_ONLINE_ARG
    MC_SD_USAGE_OFFLINE_ARG
    MC_SD_USAGE_RESET_ARG
)],

mc_vv_usage_t => [qw(
    MC_VV_USAGE_PATTR_RSRC_CLASS
    MC_VV_USAGE_PATTR_RESOURCE
    MC_VV_USAGE_DATTR_RSRC_CLASS
    MC_VV_USAGE_DATTR_RESOURCE
    MC_VV_USAGE_RSRC_ACTION_INPUT
    MC_VV_USAGE_CLASS_ACTION_INPUT
    MC_VV_USAGE_ERROR_INPUT
    MC_VV_USAGE_DEFINE_ARG
    MC_VV_USAGE_UNDEFINE_ARG
    MC_VV_USAGE_ONLINE_ARG
    MC_VV_USAGE_OFFLINE_ARG
    MC_VV_USAGE_RESET_ARG
)],

mc_action_type_t => [qw(
    MC_ACTION_TYPE_RESOURCE
    MC_ACTION_TYPE_CLASS
)],

mc_action_props_t => [qw(
    MC_RSRC_ACTION_LONG_RUNNING
    MC_RSRC_ACTION_PUBLIC
)],

mc_error_props_t => [qw(
    MC_RSRC_ERROR_PUBLIC
)],

mc_integrity_check_opts_t => [qw(
    MC_CHK_OPTS_NONE
    MC_CHK_OPTS_FIX
)],

mc_check_flags_t => [qw(
    MC_CHECK_FIXED
)],

mc_event_flags_t => [qw(
    MC_EVENT_RE_ARM
    MC_EVENT_EXPR_FALSE
    MC_EVENT_IMMED_EVAL
    MC_EVENT_REFRESH
    MC_EVENT_MISSING_PATTR
    MC_EVENT_UNASSIGN
)],


=head1 EXPORTED FUNCTIONS

For the purpose of calling the extensions, all should be prefixed
with CT::MC::  (e.g. CT::MC::start_session() ).
In the RMC C API all functions are prefixed with mc_.

 extern ct_int32_t
 start_session(                      
     contact_t         *server_list,       
     mc_session_opts_t options,
     sess_hndl_t       *sessHandle
 );

 extern ct_int32_t
 end_session(                        
     sess_hndl_t       *sessHandle
 );

 extern ct_int32_t
 get_descriptor(                     
     sess_hndl_t       *sessHandle,       
     int               *descriptor          
 );

 extern ct_int32_t
 free_descriptor(                    
     sess_hndl_t       *sessHandle,       
     int               descriptor          
 );

 # extern ct_int32_t
 # dispatch(                           
 #   mc_sess_hndl_t       session_hndl,   
 #   mc_dispatch_opts_t   options         
 # );

 extern ct_int32_t
 free_response(                      
     void             *response 
 );

 # extern ct_int32_t                                 
 # reg_event_select_bp(                
 #    mc_sess_hndl_t     sess_hndl,        
 #    mc_reg_rsp_t     **response,         
 #    mc_reg_opts_t      options,          
 #    ct_char_t         *rsrc_class_name,  
 #    ct_char_t         *select_attrs,     
 #    ct_char_t        **return_attrs,     
 #    ct_uint32_t        attr_count,       
 #    ct_char_t         *expr,             
 #    ct_char_t         *raexpr,           
 #    mc_event_cb_t     *event_cb,         
 #    void              *event_cb_arg      

 # extern ct_int32_t                                 
 # reg_event_handle_bp(                
 #    mc_sess_hndl_t       sess_hndl,      
 #    mc_reg_rsp_t       **response,       
 #    mc_reg_opts_t        options,        
 #    ct_resource_handle_t rsrc_hndl,      
 #    ct_char_t           *expr,           
 #    ct_char_t           *raexpr,         
 #    mc_event_cb_t       *event_cb,       
 #    void                *event_cb_arg    
 # );

 # extern ct_int32_t
 # reg_class_event_bp(                 
 #    mc_sess_hndl_t     sess_hndl,        
 #    mc_reg_rsp_t     **response,         
 #    mc_reg_opts_t      options,          
 #    ct_char_t         *rsrc_class_name,  
 #    ct_char_t        **return_attrs,     
 #    ct_uin32_t         attr_count,       
 #    ct_char_t         *expr,             
 #    ct_char_t         *raexpr,           
 #    mc_class_event_cb_t *event_cb,       
 #    void              *event_cb_arg      
 # );

 # extern ct_int32_t
 # unreg_event_bp(                     
 #    mc_sess_hndl_t       sess_hndl,      
 #    mc_unreg_rsp_t     **response,       
 #    mc_registration_id_t reg_id          
 # );

 extern ct_int32_t                           
 enumerate_resources_bp(               
     sess_hndl_t         *sessHandle,        
     enumerate_rsp_t     *response,       
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     ct_char_t           *select_str     
 );

 extern ct_int32_t                                 
 query_p_select_bp(                  
     sess_hndl_t         *sessHandle,      
     query_rsp_t         *response,        
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     ct_char_t           *select_str,     
     char_ptr_t          *attr_names,
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 query_d_select_bp(                  
     sess_hndl_t         *sessHandle,        
     query_rsp_t         *response,        
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     ct_char_t           *select_str,     
     char_ptr_t          *attr_names,
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 query_p_handle_bp(                  
     sess_hndl_t         *sessHandle,      
     query_rsp_t         *response,       
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,
     char_ptr_t          *attr_names,   
     ct_uint32_t          attr_count      
 );

 extern ct_int32_t
 query_d_handle_bp(                  
     sess_hndl_t         *sessHandle,      
     query_rsp_t         *response,       
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,
     char_ptr_t          *attr_names,
     ct_uint32_t          attr_count      
 );

 extern ct_int32_t 
 class_query_p_bp(                   
     sess_hndl_t         *sessHandle,        
     class_query_rsp_t   *response,     
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     char_ptr_t          *attr_names,     
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 class_query_d_bp(                   
     sess_hndl_t         *sessHandle,        
     class_query_rsp_t   *response,     
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     char_ptr_t          *attr_names,     
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 qdef_resource_class_bp(                 
     sess_hndl_t           *sessHandle,
     qdef_rsrc_class_rsp_t *response,
     errnum_t              *error,
     mc_qdef_opts_t         options,
     ct_char_t             *rsrc_class_name  
 );

 extern ct_int32_t
 qdef_p_attribute_bp(                    
     sess_hndl_t         *sessHandle,        
     qdef_pattr_rsp_t    *response,        
     errnum_t            *error,
     mc_qdef_opts_t       options,          
     ct_char_t           *rsrc_class_name,  
     ct_uint32_t          qry_class_attrs,  
     char_ptr_t          *attr_names,       
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 qdef_d_attribute_bp(                    
     sess_hndl_t         *sessHandle,        
     qdef_dattr_rsp_t    *response,        
     errnum_t            *error,
     mc_qdef_opts_t       options,          
     ct_char_t           *rsrc_class_name,  
     ct_uint32_t          qry_class_attrs,  
     char_ptr_t          *attr_names,       
     ct_uint32_t          attr_count        
 );

 extern ct_int32_t
 qdef_sd_bp(                             
     sess_hndl_t         *sessHandle,        
     qdef_sd_rsp_t       *response,        
     errnum_t            *error,
     mc_qdef_opts_t       options,          
     ct_char_t           *rsrc_class_name,  
     mc_sd_usage_t        sd_use,           
     char_ptr_t          *attr_names,            
     ct_uint32_t          attr_count             
 );

 extern ct_int32_t
 qdef_valid_values_bp(                   
     sess_hndl_t             sess_hndl,        
     qdef_valid_vals_rsp_t  *response,    
     errnum_t               *error,
     mc_qdef_opts_t          options,          
     ct_char_t              *rsrc_class_name,  
     mc_vv_usage_t           vv_use, 
     char_ptr_t             *attr_names,       
     ct_uint32_t             attr_count        
 );

 extern ct_int32_t
 qdef_actions_bp(                        
     sess_hndl_t         *sessHandle,       
     qdef_actions_rsp_t  *response,       
     errnum_t            *error,
     mc_qdef_opts_t       options,         
     ct_char_t           *rsrc_class_name,  
     ct_uint32_t          qry_class_actns,
     char_ptr_t          *action_names,
     ct_uint32_t          action_count
 );

 # extern ct_int32_t
 # qdef_err_inject_bp(                    
 #    sess_hndl_t          sess_hndl,       
 #    qdef_err_inject_rsp_t **rsp_array,       
 #    errnum_t            *error,
 #    ct_uint32_t            *array_cnt,       
 #    mc_qdef_opts_t          options,         
 #    ct_char_t              *rsrc_class_name  
 # );

 # extern ct_int32_t 
 # qdef_dependencies_bp(                   
 #    mc_sess_hndl_t          sess_hndl,       
 #    mc_qdef_rsrc_deps_rsp_t  **rsp_array,    
 #    ct_uint32_t            *array_cnt,       
 #    ct_char_t              *rsrc_class_name  
 # );

 extern ct_int32_t
 validate_rsrc_hndl_bp(                 
     sess_hndl_t             *sessHandle,       
     rsrc_hndl_rsp_t         *response,
     errnum_t                *error,
     resource_handle_array_t *rsrc_hndls 
 );

 extern ct_int32_t
 define_resource_bp(                    
     sess_hndl_t         *sessHandle,         
     define_rsrc_rsp_t   *response,          
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,   
     attribute_array_t   *attributes,
     structured_data_t   *data
 );

 extern ct_int32_t
 undefine_resource_bp(                  
     sess_hndl_t         *sessHandle,       
     undefine_rsrc_rsp_t *response,       
     errnum_t            *error,
     resource_handle_t   *rsrc_hndl,       
     structured_data_t   *data
 );

 extern ct_int32_t
 refresh_config_bp(                     
     sess_hndl_t         *sessHandle,       
     class_name_rsp_t    *response,       
     errnum_t            *error,
     ct_char_t           *rsrc_class_name  
 );

 # extern ct_int32_t
 # do_integrity_check_bp(                 
 #    mc_sess_hndl_t            sess_hndl,    
 #    mc_integrity_chk_rsp_t  **rsp_array,        
 #    ct_uint32_t              *array_cnt,    
 #    mc_integrity_check_opts_t options,      
 #    rmc_integrity_check_type_t check_type,      
 #    ct_char_t             *rsrc_class_name  
 # );

 extern ct_int32_t
 set_select_bp(                      
     sess_hndl_t         *sessHandle,        
     set_rsp_t           *response,        
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     ct_char_t           *select_str,     
     attribute_array_t   *attributes,            
 );

 extern ct_int32_t
 set_handle_bp(                         
     sess_hndl_t         *sessHandle,      
     set_rsp_t           *response,       
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,      
     attribute_array_t   *attributes,          
 );

 extern ct_int32_t
 class_set_bp(                       
     sess_hndl_t         *sessHandle,        
     class_set_rsp_t     *response,       
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,  
     attribute_array_t   *attributes,            
 );

 extern ct_int32_t
 invoke_action_bp(                   
     sess_hndl_t         *sessHandle,    
     action_rsp_t        *response,    
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,    
     ct_char_t           *action_name,  
     structured_data_t   *sd
 );

 extern ct_int32_t
 invoke_class_action_bp(
     sess_hndl_t         *sessHandle,    
     action_rsp_t        *response,    
     errnum_t            *error,
     ct_char_t           *rsrc_class_name,    
     ct_char_t           *action_name,  
     char_ptr_t          *node_names,
     ct_uint32_t          name_count,
     structured_data_t   *data        
 );

 # extern ct_int32_t
 # enum_constraints_bp(                
 #    mc_sess_hndl_t         sess_hndl,      
 #    mc_constraint_rsp_t  **response,      
 #    ct_resource_handle_t   rsrc_hndl       
 # );

 extern ct_int32_t
 online_bp(                          
     sess_hndl_t         *sessHandle,      
     rsrc_hndl_rsp_t     *response,       
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,      
     char_ptr_t          *node_names,
     ct_uint32_t          name_count,    
     structured_data_t   *data
 );

 extern ct_int32_t
 offline_bp(                         
     sess_hndl_t         *sessHandle,      
     rsrc_hndl_rsp_t     *response,       
     errnum_t            *error,
     mc_offline_opts_t    options,
     resource_handle_t    rsrc_hndl,       
     structured_data_t   *data
 );

 extern ct_int32_t
 reset_bp(        
     sess_hndl_t         *sessHandle,      
     rsrc_hndl_rsp_t     *response,       
     errnum_t            *error,
     resource_handle_t    rsrc_hndl,       
     structured_data_t   *data
 );
 
 # extern ct_in32_t
 # constraint_advisory_bp(             
 #    mc_sess_hndl_t                       sess_hndl,      
 #    mc_rsrc_hndl_rsp_t                 **response,       
 #    ct_resource_handle_t                 rsrc_hndl,      
 #    rmc_constraint_alternate_resource_t *constraints,    
 #    ct_uint32_t                          count           
 # );

 # extern ct_int32_t
 # get_control_log_bp(                 
 #    mc_sess_hndl_t         sess_hndl,    
 #    mc_control_log_rsp_t **response,     
 #    ct_resource_handle_t   rsrc_hndl     
 # );


=head1 AUTHOR

Licensed Materials - Property of IBM

(C) COPYRIGHT International Business Machines Corp. 1998, 2001.
All Rights Reserved.

US Government Users Restricted Rights - Use, duplication or
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.


=head1 VERSION

RSCT Version 2.2 


=head1 SEE ALSO

rmccli, CT::CT, CT::MCerr, CT::RM

=cut
